# AT Firmware Description
---
[AT Firmware](docs/AT/0.固件下载.md) is developed by MXCHIP, and the software Command system runs on EMW series Wi-Fi or Wi-Fi/BT modules.

Using the AT firmware and AT Commands, users can easily and quickly add Wi-Fi/BT communication functions for embedded devices. It greatly shortens the development cycle and achieves rapid listing.


## 1.Firmware types
According to the type of AT Command supported by firmware, AT firmware can be divided into two categories:

* Basic AT firmware: Only basic AT Commands are supported.
* Directly connect cloud AT firmware: Only connecting cloud AT commands and necessary system AT commands are supported.



## 2.Support model
AT firmware and Commands can be run on:

  -  [EMW3165](http://www.mxchip.com/product/wifi_product/29)
  -  [EMW3166](http://www.mxchip.com/product/wifi_product/41)
  -  [EMW3031](http://www.mxchip.com/product/wifi_product/39)
  -  [EMW3080B](http://www.mxchip.com/product/wifi_product/49)
  -  [EMW3239](http://www.mxchip.com/product/wifi_product/42)
  -  [EMW3060](http://www.mxchip.com/product/wifi_product/56)
  -  [MOC108 / MOC108A](http://www.mxchip.com/product/wifi_product/54)
  -  [MX1290 / MX1290V2](http://www.mxchip.com/product/wifi_product/55)
  

The BT Bluetooth Command of AT firmware can run on:
  -  [EMW3239](http://www.mxchip.com/product/wifi_product/42)




## 3.Version Description
* **vx.x** stands for firmware version number.
Here, firmware version number can be queried by sending Commands: `AT+FWVER\r`

## 4.Conditions of Usage
1. WiFi module: the module has pre-burned AT firmware;
2. Hardware connection: UART of traditional MCU (or serial uart debug tool) and UART of Wi-Fi module are connected;
3. Software implementation: The main MCU controls the Wi-Fi module through AT Command parsing.
4. Data flow:
   1. The master MCU of the slave device uploads to the cloud through the Wi-Fi module.
   2. From the cloud through the Wi-Fi module, download to the main MCU, control equipment.


## 5. Types of working modes
AT firmware provides four working modes, including AT Command control mode, transparent transmission mode, BOOT mode and test mode.

### 1) AT command control mode:
The module that burns the new version of AT firmware will enter AT Command mode by default when the BOOT is low when it is first powered on after it is manufactured, and will not start any AP, STAIION, TCP or UDP functions. If the above functions need to be turned on, users need to set them one by one through AT Commands. Once set, they can immediately effective.

In this mode, users can control and configure modules through AT Commands. For detailed Commands, please refer to: [AT Command Description](/docs/AT/2.指令说明.md).



### 2) Transparent transmission mode:
In this mode, the module user serial port data is automatically sent to the WiFi radio terminal, while the WiFi radio terminal receives data automatically sent to the module user serial port.



### 3) BOOT mode:
In BOOT mode, developers can upgrade module firmware through Ymodem file transfer protocol of serial port.


### 4) MFG production measurement mode:
In MFG mode, you can view production log information.



## 6.Pin status of each mode:
AT firmware detects the status of BOOT and STATUS pins when power-on, and guides modules into different working modes, such as table (except EMW3080):

|BOOT|STATUS|Working mode|
|:---:|:---:|:--- |
|0    |0    |After Reset，Enter MFG production and measurement mode|
|0    |1    |After Reset，Enter BOOT  mode|
|1 or suspended|1 or suspended   |After Reset，Enter Transparent Transfer Mode or AT Command Control Mode|

Since EMW3080B does not specify STATUS pins, the judgment of AT firmware's working mode only needs to look at the following table: BOOT pin status or user serial input content when module is reset:


|BOOT|User Serial Port Input |Working mode|
|:---:|:---:     |:---   |
|x    |#         |After Reset，Enter MFG production and measurement mode|
|0    |无        |After Reset，Enter BOOT  mode|
|1 or suspended  |无       |After Reset，Enter AT Command Control Mode|



**1. AT Command mode (Wi_Fi/BT support) ---> Wi-Fi transparent transmission mode**

* Send Commands: `AT+CIPSENDRAW\r`
* Return: `OK`


**2. AT Command Mode (BT/RFCOMM) - -> BT Transparent Transport Mode**

* Send Commands: `AT+BTSENDRAW\r`
* Return: `OK`

> Note: Currently only EMW3239 supports classical Bluetooth transmission mode (using BT RFCOMM protocol) and BLE transmission is not supported.



**3. Transparent Transport Mode - > AT Command Mode**
When it is necessary to enter AT Command mode from WiFi transparent transmission mode or BT transparent transmission mode, it is necessary to:

* Send Commands:`+++`
* Return: `OK`


> Note:
> Wi-Fi transmission mode and BT transmission mode can not be switched to each other, so we must first switch from transparent transmission mode to AT Command mode, and then enter the corresponding transmission mode through different AT Commands.


## 8. Factory Configuration
### 1) Default parameters
AT firmware supports MXCHIP factory settings with the following parameters:

- **AT Command serial port**: baud rate 115200, data bit 8, stop bit 1, check bit none, flow control none;
- **Wi-Fi Settings**: Soft AP or Station mode is not activated by default. Users need to define the name and password of Soft_AP and AP connected by Station mode respectively.
- **IP Address**: Default Soft_AP mode is 10.10.10.1, subnet mask is 255.255.255.0, gateway is 10.10.10.1;
- **DHCP Server**: Enabling;
- Bonjour Server**: Not enabled;
- **TCP Server**: Not enabled;
- **HTTP Server**: No;
- **Command echo**: The echo function is turned on by default.
- **Event Notification**: The notification function is turned on by default.


### 2) Resumption of factory
**(1) Adoption of Directives**
Input in AT Command mode:

* Send Command: `AT+FACTORYr`
* Return: `OK`

All user settings can be cleared and MXCHIP module factory settings can be restored.


**(2) By pressing the button**
In AT Command mode or transparent transmission mode, all user settings can be cleared and MXCHIP module factory settings can be restored by continuously lowering the ** Easylink ** pin of the module for >= 5 seconds.



## 9. Pin Distribution
When the module leaves the factory, the function pins that have been set up through AT firmware include:

* **UART Serial Port**:  Used for log information output and AT Command sending and receiving in various working modes, including Debug debugging serial port (view running log information) and User user serial port (send and receive AT Commands);
* **WiFi mode LED indicator lamp**: Used to display the current system WiFi communication status, including: system indicator lamp and radio frequency indicator lamp;


### 1) UART Serial Port
In AT firmware, UART serial ports are different for different modules in different modes and different serial ports for information output.

Usually, the user serial port is used to send and receive AT Commands, and debugging the serial port is used to view the running log information.

The distribution of serial port pins for specific model modules is as follows:

| Model | Boot and MFG  Information Port | AT Command and Transmit Port | Normal Working Log and CLI Debugging Command Port| 
|:---|:---:|:---:|:---:|
|3060 |Pin9, Pin10, 921600bps|Pin9, Pin10, 115200bps|Pin21，Pin22，115200bps|
|3165|Pin29, Pin30, 921600bps|Pin29, Pin30, 115200bps|Pin8，Pin12，115200bps|
|3166|Pin29, Pin30, 921600bps|Pin29, Pin30, 115200bps|Pin8，Pin12，115200bps|
|3239|Pin29, Pin30, 921600bps|Pin29, Pin30, 115200bps|Pin8，Pin12，115200bps|
|3162|Pin22, Pin23, 921600bps|Pin22, Pin23, 115200bps|Pin14，Pin4，115200bps|
|3031|Pin9, Pin10, 921600bps|Pin9, Pin10, 115200bps|Pin21，Pin22，115200bps|
|3080B|Pin9, Pin10, 921600bps|Pin9, Pin10, 115200bps|Pin21，Pin22，115200bps|


> Note: User serial port refers to the USER_UART serial port specially marked on the module Datasheet. Debug_UART Serial Port is the Debug_UART Serial Port specially marked on the module Datasheet. Usually, user serial port is UART serial port of Aduino interface on MXKit development board.



### 2) WiFi mode LED indicator
#### a. System Indicator Light (SYS_LED)
The pin number and function description of the system indicator lamp are as shown in the table (the pin number should be designed and drawn out by the user himself):


|number |module model|pin|
|:---:|:---:|:---:|
| 1 | 3165 | Pin33|
| 2 | 3166 | Pin33|
| 3 | 3162 | On the module (green)|
| 4 | 3080B | Pin19|
| 5 | 3031 | on the module|
| 6 | 3239 | Pin33|
| 7 | 3060 | None|


The system LED indicator is used to display the current system operation status.

1. Easylink mode:When SSID and password are not acquired by the module after the distribution network starts, the high and low levels output alternately, and the lights flash.

When the module obtains the SSID and password, the high and low level output alternately, and the lamp flashes slowly; after the distribution network is successful, the low level, the lamp is always on.

2. AP mode: After successful initialization, low level, light is always on.
3. STATION mode: After successful initialization, the light is always on at low level.
4. AP + STATION dual mode: After successful initialization, low level, light always on.

Refer to the system indicator circuit design:

![sys_led](image/4.at_pin_config/sys_led.png)


#### b. Radio Frequency Indicator Lamp (RF_LED)
Radio Frequency Indicator Pin Number and Function Commands as shown in Table (pin number is required to be designed and drawn out by the user himself):

|number |module model |pin|
|:---:|:---:|:---:|
| 1 | 3165 | Pin31|
| 2 | 3166 | Pin31|
| 3 | 3162 | on the module (red)|
| 4 | 3080B | None|
| 5 | 3031 | Pin30|
| 6 | 3239 | Pin31|
| 7 | 3060 | None|

The radio frequency LDE indicator lamp is used to indicate the wireless Wi-Fi connection status of the system.

1. Easylink mode: when the distribution network is successful, the output is low and the light is on; when the distribution network is unsuccessful, the output is high and the light is off.
2. AP mode: After successful initialization, AP opens ON, outputs low level and lights; when AP closes OFF, it outputs high level and lights out.
3. STATION mode: After successful initialization, when STATION is connected to ON, the output is low-level and the light is on; when STATION is connected to OFF, the output of high-level lamp is off.

Refer to the system indicator circuit design:

![rf_led](image/4.at_pin_config/rf_led.png)


More detail about module peripheral circuit design can refer to the application notes of each module AN.






































